%==============================================================================
% Estilo para teses/dissertações do PGMSB-UNEB:
% baseada na classe memoir
% Autoria: prof. Marcos Batista Figueredo
% email: mbfigueredo@uneb.br
% Programa de Pós-Graduação em Modelagem e Simulação de Biossistemas --- PPGMSB
% Alagoinhas, Bahia, Brasil
% http://www.ppgmsb.uneb.br
%==============================================================================
% definição da classe e versão
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{classPPGMSB}[01/12/2023 Classe padrao teses]
%pacotes inciais
\RequirePackage{ifthen}


% Definições iniciais
\newboolean{tese}
\newboolean{diss}
\newboolean{qlf}
\newboolean{ing}
\setboolean{tese}{false}
\setboolean{diss}{false}
\setboolean{qlf}{false}
\setboolean{ing}{false}

%================== DEFININDO OPÇÕES DA CLASSE ==========
\DeclareOption{tese}{\setboolean{tese}{true}}
\DeclareOption{qlf}{\setboolean{qlf}{true}}
\DeclareOption{diss}{\setboolean{diss}{true}}
\DeclareOption{ing}{\setboolean{ing}{true}}

% Repassa demais opcoes a memoir	
\DeclareOption*{%
	\PassOptionsToClass{\CurrentOption}{memoir}%
}
\ProcessOptions\relax
\LoadClass[oneside]{memoir}

%===================== COMANDOS =========================
\newcommand{\@NaturezaTrabalho}{}
\newcommand{\NaturezaTrabalho}[1]{\renewcommand{\@NaturezaTrabalho}{#1}}

%------------------------------------------------------------------------
% COMANDOS DE INDENTIFICAÇÃO
%------------------------------------------------------------------------
% O nome da instituição que oferece o programa de pós-graduação
\newcommand{\@universidade}{}
\newcommand{\universidade}[1]{\renewcommand{\@universidade}{#1}}

% O nome do Programa 
\newcommand{\@programa}{}
\newcommand{\programa}[1]{\renewcommand{\@programa}{#1}}

% O nome do Departamento (quando for o caso)
\newcommand{\@departamento}{}
\newcommand{\departamento}[1]{\renewcommand{\@departamento}{#1}}

% O nome do Departamento (quando for o caso)
\newcommand{\@department}{}
\newcommand{\department}[1]{\renewcommand{\@department}{#1}}

% O nome da instituição que oferece o programa de pós-graduação
\newcommand{\@university}{}
\newcommand{\university}[1]{\renewcommand{\@university}{#1}}

% O nome do Programa 
\newcommand{\@program}{}
\newcommand{\program}[1]{\renewcommand{\@program}{#1}}

% Título completo da dissertação ou tese
\newcommand{\Departamento}{%
	\ifthenelse{\boolean{ing}}{
		\@department
	}{
		\@departamento
	}
}

\newcommand{\Universidade}{%
	\ifthenelse{\boolean{ing}}{
		\@university
	}{
		\@universidade
	}
}

\newcommand{\Programa}{%
	\ifthenelse{\boolean{ing}}{
		\@program
	}{
		\@programa
	}
}


% O nome do Departamento (quando for o caso)
\newcommand{\@tipo}{}
\newcommand{\tipo}[1]{\renewcommand{\@tipo}{#1}}

% Título completo da dissertação ou tese
\RequirePackage{xstring}
\RequirePackage{etoolbox} % Para usar \ifdefempty
\RequirePackage{ifthen}
\RequirePackage{environ} % <-- Adicionado para permitir \Collect@Body
% Limitação de caracteres no título
\newcommand{\@tituloBR}{}
\newcommand{\tituloBR}[1]{%
	\StrLen{#1}[\tempLength] % Calcula o tamanho da string e armazena em \tempLength
	\ifnum\tempLength>150
	\PackageError{classPPGMSB}{O título excede o limite de 150 caracteres.}{Reduza o comprimento do título.}%
	\else
	\renewcommand{\@tituloBR}{#1}%
	\fi
}

% Título completo da dissertação ou tese INGLES
% Título completo da dissertação ou tese em inglês
\newcommand{\@tituloEN}{}
\newcommand{\tituloEN}[1]{%
	\StrLen{#1}[\tempLength] % Calcula o tamanho da string e armazena em \tempLength
	\ifnum\tempLength>150
	\PackageError{classPPGMSB}{The title exceeds the 150-character limit.}{Please shorten the title.}%
	\else
	\renewcommand{\@tituloEN}{#1}%
	\fi
}

% Título completo da dissertação ou tese
\newcommand{\titulo}{%
	\ifthenelse{\boolean{ing}}{
		\@tituloEN
	}{
		\@tituloBR
	}
}



% =================== SUBTÍTULO EM PORTUGUÊS E INGLÊS =================== %

% Subtítulo em português (inicializa vazio)
\newcommand{\@subtituloBR}{}
\newcommand{\subtituloBR}[1]{%
	\StrLen{#1}[\tempLength] % Mede o comprimento da string
	\ifnum\tempLength>80
	\PackageError{classPPGMSB}{O subtítulo em português excede o limite de 80 caracteres.}{Reduza o comprimento do subtítulo para caber em uma única linha.}%
	\else
	\renewcommand{\@subtituloBR}{#1}%
	\fi
}

% Subtítulo em inglês (inicializa vazio)
\newcommand{\@subtituloEN}{}
\newcommand{\subtituloEN}[1]{%
	\StrLen{#1}[\tempLength] % Mede o comprimento da string
	\ifnum\tempLength>80
	\PackageError{classPPGMSB}{The subtitle in English exceeds the 80-character limit.}{Please shorten the subtitle to fit in a single line.}%
	\else
	\renewcommand{\@subtituloEN}{#1}%
	\fi
}

% =================== SUBTÍTULO CONDICIONAL =================== %

\newcommand{\subtitulo}{%
	\ifthenelse{\boolean{ing}}{
		\@subtituloEN
	}{
		\@subtituloBR
	}
}




% O nome completo do autor da dissertação ou tese
\newcommand{\@autor}{}
\newcommand{\autor}[1]{\renewcommand{\@autor}{#1}}

\newcommand{\@emailAutor}{}
\newcommand{\emailAutor}[1]{\renewcommand{\@emailAutor}{#1}}

\newcommand{\@urlLink}{}
\newcommand{\urlLink}[1]{\renewcommand{\@urlLink}{#1}}
%\urlLink{http://www.exemplo.com}{Visite o nosso site}

\newcommand{\@msbDOI}{}
\newcommand{\msbDOI}[1]{\renewcommand{\@msbDOI}{#1}}
\newcommand{\showDOI}{\href{https://doi.org/\@msbDOI}{DOI: \@msbDOI}}

\newcommand{\orientador}[3]{%
	\gdef\@orientadorNome{#1}%
	\gdef\@orientadorFiliacao{#2}%
	\gdef\@orientadorSigla{#3}%
}


\newcommand{\CoorientadorA}[3]{%
	\gdef\@coorientadorANome{#1}%
	\gdef\@coorientadorAFiliacao{#2}%
	\gdef\@coorientadorASigla{#3}%
}

\newcommand{\CoorientadorB}[3]{%
	\gdef\@coorientadorBNome{#1}%
	\gdef\@coorientadorBFiliacao{#2}%
	\gdef\@coorientadorBSigla{#3}%
}

\newcommand{\CoorientadorC}[3]{%
	\gdef\@coorientadorCNome{#1}%
	\gdef\@coorientadorCFiliacao{#2}%
	\gdef\@coorientadorCSigla{#3}%
}

\newcommand{\@areaDeConcentracaoBR}{}
\newcommand{\areaDeConcentracaoBR}[1]{\renewcommand{\@areaDeConcentracaoBR}{#1}}

\newcommand{\@linhaPesquisaBR}{}
\newcommand{\linhaPesquisaBR}[1]{\renewcommand{\@linhaPesquisaBR}{#1}}

\newcommand{\@areaDeConcentracaoEN}{}
\newcommand{\areaDeConcentracaoEN}[1]{\renewcommand{\@areaDeConcentracaoEN}{#1}}

\newcommand{\@linhaPesquisaEN}{}
\newcommand{\linhaPesquisaEN}[1]{\renewcommand{\@linhaPesquisaEN}{#1}}


% Mês e ano da defesa
\newcommand{\@dataDefesa}{}
\newcommand{\dataDefesa}[1]{\renewcommand{\@dataDefesa}{#1}}

\newcommand{\@horaDefesa}{}
\newcommand{\horaDefesa}[1]{\renewcommand{\@horaDefesa}{#1}}

% Mês e ano da defesa
\newcommand{\@localDefesa}{}
\newcommand{\localDefesa}[1]{\renewcommand{\@localDefesa}{#1}}

% Banca

% Banca examinadora
\newcommand{\membroBancaA}[4]{%
	\gdef\@mANome{#1}%
	\gdef\@mAFiliacao{#2}%
	\gdef\@mASigla{#3}%
	\gdef\@mATipo{#4}%
}
\newcommand{\membroBancaB}[4]{%
	\gdef\@mBNome{#1}%
	\gdef\@mBFiliacao{#2}%
	\gdef\@mBSigla{#3}%
	\gdef\@mBTipo{#4}%
}
\newcommand{\membroBancaC}[4]{%
	\gdef\@mCNome{#1}%
	\gdef\@mCFiliacao{#2}%
	\gdef\@mCSigla{#3}%
	\gdef\@mCTipo{#4}%
}
\newcommand{\membroBancaD}[4]{%
	\gdef\@mDNome{#1}%
	\gdef\@mDFiliacao{#2}%
	\gdef\@mDSigla{#3}%
	\gdef\@mDTipo{#4}%
}
\newcommand{\membroBancaE}[4]{%
	\gdef\@mENome{#1}%
	\gdef\@mEFiliacao{#2}%
	\gdef\@mESigla{#3}%
	\gdef\@mETipo{#4}%
}
\newcommand{\membroBancaF}[4]{%
	\gdef\@mFNome{#1}%
	\gdef\@mFFiliacao{#2}%
	\gdef\@mFSigla{#3}%
	\gdef\@mFTipo{#4}
}


\newcommand{\opcoesDocumento}{
	\ifthenelse{\boolean{tese}}{
		\ifthenelse{\boolean{ing}}{%valor se verdadeiro
			\NaturezaTrabalho{Thesis submitted to the Bahia State University, in the Postgraduate Program in Modeling and Simulation of Biosystems, as a partial requirement for obtaining the title of PhD in Biosystems Modeling and Simulation.}
			\tipo{Phd Thesis}
		}{%valor se falso
			\NaturezaTrabalho{Tese de Doutorado submetida a Universidade do Estado da Bahia, no Programa de Pós-Graduação em Modelagem e Simulação de Biosistemas, como requisito parcial para a obtenção do tíitulo de Doutor em Modelagem e Simulação de Biosistemas.}
			\tipo{Tese}
		}
	}{}

	\ifthenelse{\boolean{diss}}{
		\ifthenelse{\boolean{ing}}{
			\NaturezaTrabalho{Master's thesis submitted to the State University of Bahia, in the Graduate Program in Biosystems Modeling and Simulation, as a partial requirement to obtain the title of Master in Biosystems Modeling and Simulation.}
			\tipo{Master's Thesis}
		}{
			\NaturezaTrabalho{Dissertação de Mestrado submetida a Universidade do Estado da Bahia, no Programa de Pós-Graduação em Modelagem e Simulação de Biosistemas, como requisito parcial para a obtenção do tíitulo de Mestre em Modelagem e Simulação de Biositemas.}
			\tipo{Dissertação}
		}
	}{}
	\ifthenelse{\boolean{qlf}}{
		\NaturezaTrabalho{Exame de qualificação submetida a Universidade do Estado da Bahia, no Programa de Pós-Graduação em Modelagem e Simulação de Biosistemas.}
		\tipo{Exame de Qualificação}
	}{}

}

%====================== DEFININDO CORES PADRÃO =========
\RequirePackage{xcolor}
\definecolor{ppgmsbC1}{HTML}{00303A}
\definecolor{ppgmsbC2}{HTML}{266054}
\definecolor{ppgmsbC3}{HTML}{19A340}
%=======================================================

%====================== DEFINIÇÕES GERAIS =========
% Defina as margens padrão do documento aqui (fora do comando)
\RequirePackage{geometry}
\geometry{
	a4paper,            % Define o tamanho do papel (A4)
	left=2.5cm,         % Margem esquerda
	right=2.5cm,        % Margem direita
	top=2.5cm,          % Margem superior
	bottom=2.5cm,       % Margem inferior
	headsep=1cm,      % Aumenta a distância entre cabeçalho e texto
	footskip=1cm,     % Ajusta a distância entre texto e rodapé
	includeheadfoot,    % Inclui cabeçalho e rodapé na área total
	heightrounded       % Ajusta a altura do texto para evitar erros
}

% Espaçamento de 1,5 linhas
\OnehalfSpacing


% FONTE
\RequirePackage[T1]{fontenc}    % Codificação de fonte T1
\RequirePackage{lmodern} 
\RequirePackage{microtype}
\renewcommand\familydefault{\sfdefault}  
\renewcommand{\normalsize}{\fontsize{12}{14}\selectfont}  % Texto normal: 12pt
\renewcommand{\large}{\fontsize{14}{16}\selectfont}       % Equivalente a Word 14pt
\renewcommand{\Large}{\fontsize{16}{18}\selectfont}       % Equivalente a Word 16pt
\renewcommand{\LARGE}{\fontsize{18}{20}\selectfont}       % Equivalente a Word 18pt
\renewcommand{\huge}{\fontsize{20}{22}\selectfont}        % Compatível com telas grandes
\renewcommand{\Huge}{\fontsize{24}{26}\selectfont}        % Texto destacado compatível com Word/Web

\RequirePackage{graphicx}
% Suporte para acentuação e idiomas europeus
%\RequirePackage{algpseudocode}
\RequirePackage[linesnumbered,ruled,vlined]{algorithm2e}


\RequirePackage[utf8]{inputenc} % Codificação de entrada UTF-8
\RequirePackage[english,brazil]{babel} % Suporte para Inglês e Português Brasileiro
\RequirePackage{placeins}
%=======================================================

% ==================== PACOTES MATEMÁTICOS E FISICOS
\RequirePackage{amsmath}  % Melhorias na formatação matemática (\numberwithin, \text, etc.)
\RequirePackage{amssymb}  % Conjuntos adicionais de símbolos matemáticos
\RequirePackage{amsfonts} % Fontes matemáticas adicionais (ex: \mathbb)
\RequirePackage{physics}  % Facilita a notação matemática de derivadas, vetores, tensores
\RequirePackage{siunitx}  % Formatação correta de unidades físicas (ex: \SI{9.8}{\meter\per\second\squared})
\RequirePackage{mhchem}   % Notação química e reações químicas (ex: \ce{H2O})
\RequirePackage{circuitikz} % Desenho de circuitos elétricos e eletrônicos
\RequirePackage{tikz-feynman} % Diagramas de Feynman para Física de Partículas
\RequirePackage{pgfplots} % Gráficos científicos em LaTeX

%======================== TABELAS E FIGURAS ALGORTIMOS ============
\renewcommand{\thefigure}{\thechapter.\arabic{figure}}
\numberwithin{figure}{chapter} % Garante que a numeração siga o capítulo

\renewcommand{\thetable}{\thechapter.\arabic{table}} % Formato Capítulo.Tabela
\numberwithin{table}{chapter} % Reinicia a numeração das tabelas a cada capítulo

% Configuração de numeração e tradução para algorithm2e
\renewcommand{\thealgocf}{\thechapter.\arabic{algocf}} % Formato Capítulo.Algoritmo
\numberwithin{algocf}{chapter} % Reinicia a numeração dos algoritmos a cada capítulo
\SetAlgorithmName{Algoritmo}{Algoritmo}{Lista de Algoritmos} % Tradução do nome para português


%======================== CAPA ============================
\newcommand{\makeCapa}{
	\thispagestyle{empty}
	\begingroup
	\begin{flushright}
		{\Huge\textcolor{ppgmsbC3}{\MakeUppercase{\@tipo}}}
		\vskip 0.3cm
		\begingroup
		\color{ppgmsbC1} % Define a cor da linha
		\vbox{\hrule height 2pt width \textwidth}
		\endgroup
		{\normalfont \@dataDefesa}
		\vskip 1cm
		{\LARGE\bfseries \titulo\par}
		\ifx\subtitulo\@empty
		% Não imprime nada se o subtítulo não estiver definido
		\else
		\vskip 0.5cm % Espaçamento entre título e subtítulo
		{\large \subtitulo\par}
		\fi
		\vskip 1.5cm
		{\large\bfseries \@autor}
		\vskip 0.5 cm
		{\@localDefesa}
		\vskip 0.5cm
		{\@emailAutor}
		\vskip 2cm
		{\bfseries \ifthenelse{\boolean{ing}}{supervision of:}{orientado por:}}	
		
		{\normalfont \@orientadorNome}
		
		{\normalfont \@orientadorFiliacao}
	\end{flushright}
	\vspace*{\fill} % Preenche todo o espaço disponível antes das imagens
	\noindent
	\begin{minipage}{\textwidth} % Minipage para garantir alinhamento correto
		\centering
		\includegraphics[height=2.5cm]{figuras/logo_uneb.jpg}
		\hfill
		\includegraphics[height=2.5cm]{figuras/ppgmsbLogo.png}
	\end{minipage}
	\endgroup
	\clearpage
}

%======================== FIM CAPA ============================

%------------------------------------------------------------------------
% CRIA O COMANDO DA CONTRA-CAPA
%------------------------------------------------------------------------
\newcommand{\makeContraCapa}{
	\newpage
	\thispagestyle{empty}
	\begin{center}
		{\LARGE\bfseries \Universidade}\par
		{\Large\Departamento}\par
		{\large\selectfont \Programa}
		\vskip 2cm
		{\@autor}
		\vskip 2cm
		{\Large \bfseries \titulo\par}
		{\large \subtitulo\par}
		\vskip 2cm
	\end{center}
	\begin{flushright}
		\begin{list}{}{
				\setlength{\leftmargin}{5cm}
				\setlength{\rightmargin}{0cm}
				\setlength{\labelwidth}{0pt}
				\setlength{\labelsep}{\leftmargin}}
			
			\item{\normalfont \@NaturezaTrabalho}
			
			\begin{list}{}{
					\setlength{\leftmargin}{0cm}
					\setlength{\rightmargin}{0cm}
					\setlength{\labelwidth}{0pt}
					\setlength{\labelsep}{\leftmargin}}
				
				\item \ifthenelse{\boolean{ing}}{Interdisciplinary Field}{Área de conhecimento: Interdisciplinar}
				\item \ifthenelse{\boolean{ing}}{Major Field: \@areaDeConcentracaoEN}{Área de Concentração: \@areaDeConcentracaoBR}
				\item \ifthenelse{\boolean{ing}}{Research Area: \@linhaPesquisaEN}{Linha de Pesquisa: \@linhaPesquisaBR}
				
				\item \ifthenelse{\boolean{ing}}{Advisor:}{Orientador:} \@orientadorNome
				\newline \hspace*{1cm}
				% Verifica se cada Co-Orientador foi definido
				\ifthenelse{\equal{\@coorientadorANome}{}}{}{\item \ifthenelse{\boolean{ing}}{Co-advisor:}{Coorientador:} \@coorientadorANome - (\@coorientadorASigla),}
				\ifthenelse{\equal{\@coorientadorBNome}{}}{}{\item \ifthenelse{\boolean{ing}}{Co-advisor:}{Coorientador:} \@coorientadorBNome - (\@coorientadorBSigla),}
				\ifthenelse{\equal{\@coorientadorCNome}{}}{}{\item \ifthenelse{\boolean{ing}}{Co-advisor:}{Coorientador:} \@coorientadorCNome - (\@coorientadorCSigla)}
				
			\end{list}
		\end{list}
	\end{flushright}
	\begin{center}
		\ifthenelse{\boolean{ing}}{URL}{URL do documento original:}
		\@urlLink\par
		\showDOI
	\end{center}
	\vfill
	\begin{center}
		\@localDefesa  \\\@dataDefesa
	\end{center}
	\clearpage
}

%======================== FIM CONTRA-CAPA ============================

%======================== FOLHA DE APROVAÇÃO ============================
\newcommand{\@numeroMembrosBanca}{}
\newcommand{\numeroMembrosBanca}[1]{%
	\ifnum#1=3 \renewcommand{\@numeroMembrosBanca}{#1}%
	\else\ifnum#1=4 \renewcommand{\@numeroMembrosBanca}{#1}%
	\else\ifnum#1=5 \renewcommand{\@numeroMembrosBanca}{#1}%
	\else\ifnum#1=6 \renewcommand{\@numeroMembrosBanca}{#1}%
	\else
	\PackageError{banca}{Número de membros inválido: #1. Deve ser 3, 4, 5 ou 6.}{Escolha um valor válido.}
	\fi\fi\fi\fi
}


\newcommand{\folhaAprovacao}{
	\newpage
	\thispagestyle{empty}
	\begin{center}
		{\LARGE\selectfont \bfseries \Universidade}\par
		{\Large \Departamento}\par
		{\large \Programa}
		\vskip 1cm
		{\@autor}
		\vskip 0.5cm
		{\Large\selectfont \bfseries \titulo\par}
		{\large\selectfont\subtitulo\par}
		\vspace*{1cm}
		{\@NaturezaTrabalho\par}
		\vspace*{0.5cm}
		{\@localDefesa\par\@dataDefesa\par}		
		\ifthenelse{\boolean{ing}}{\bfseries THESIS COMMITTEE}{\bfseries BANCA EXAMINADORA}
	\end{center}
	\vspace*{0.5cm}
% BANCA COM 3 MEMBROS
% Espaço reservado para os membros da banca
	% Espaço reservado para os membros da banca
	\ifthenelse{\equal{\@numeroMembrosBanca}{3}}{
		\noindent\begin{minipage}[t]{0.45\textwidth}\vspace{0pt}
			\setlength{\parindent}{0pt} % Remove o recuo dentro da minipage	
			% Orientador
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@orientadorNome\par}
			\vskip -0.01cm	
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\@orientadorFiliacao\par}
			\vskip -0.01cm
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\ifthenelse{\boolean{ing}}{Thesis Advisor}{Orientador}\par}
			%Fim orientador
			\vskip 2cm
			%Membro 1
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mBNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mBFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mBTipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 1
		\end{minipage}\hfill %Fim minipage 1
		%Membro 2
		%Membro 1
		\noindent\begin{minipage}[t]{0.45\textwidth}\vspace{0pt}		
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mANome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mAFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mATipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
		\end{minipage}
		%fim Membro 2
	}{}
	%============= banca com 4 membros================
	% BANCA COM 3 MEMBROS
	% Espaço reservado para os membros da banca
	\vskip 20pt
	\ifthenelse{\equal{\@numeroMembrosBanca}{4}}{
		\noindent\begin{minipage}[t]{0.45\textwidth}\vspace{0pt}	
			% Orientador
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont\@orientadorNome\par}
			\vskip 0.01pt	
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\@orientadorFiliacao\par}
			\vskip 1pt
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\ifthenelse{\boolean{ing}}{Thesis Advisor}{Orientador}\par}
			%Fim orientador
			\vspace{3\baselineskip}
			%Membro 1
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mBNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mBFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mBTipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 1
		\end{minipage}\hfill %Fim minipage 1
		\noindent\begin{minipage}[t]{0.45\textwidth}\vspace{0pt}
			%Membro 2
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mANome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mAFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mATipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			\vspace{3\baselineskip}
			%Membro 3
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mCNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mCFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mATipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 3
		\end{minipage}
	}{}
	%============== fim 4 membros====================
	
	%================ banca 5 membros =================
	% Espaço reservado para os membros da banca
	\vskip 15pt
	\ifthenelse{\equal{\@numeroMembrosBanca}{5}}{
		\noindent\begin{minipage}[t]{0.45\textwidth}\vspace{0pt}	
			% Orientador
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont\@orientadorNome\par}
			\vskip 0.01pt	
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\@orientadorFiliacao\par}
			\vskip 1pt
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\ifthenelse{\boolean{ing}}{Thesis Advisor}{Orientador}\par}
			%Fim orientador
			\vspace{3\baselineskip}
			%Membro 1
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mBNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mBFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mBTipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 1
			\vspace{3\baselineskip}
			%Membro 1
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mDNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mDFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mDTipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 1
		\end{minipage}\hfill %Fim minipage 1
		\noindent\begin{minipage}[t]{0.45\textwidth}\vspace{0pt}
			%Membro 2
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mANome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mAFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mATipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			\vspace{3\baselineskip}
			%Membro 3
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mCNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mCFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mCTipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 3
		\end{minipage}
	}{}
	
	
	%================ banca 6 membros =================
	% Espaço reservado para os membros da banca
	\vskip 10pt
	\ifthenelse{\equal{\@numeroMembrosBanca}{6}}{
		\noindent\begin{minipage}[t]{0.45\textwidth}\vspace{0pt}
			\setlength{\parindent}{0pt} % Remove o recuo dentro da minipage	
			% Orientador
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont\@orientadorNome\par}	
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\@orientadorFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\ifthenelse{\boolean{ing}}{Thesis Advisor}{Orientador}\par}
			%Fim orientador
			\vspace{2.5\baselineskip}
			%Membro 1
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mBNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mBFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\noindent
				\ifthenelse{\equal{1}{\@mBTipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 1
			\vspace{2.5\baselineskip}
			%Membro 1
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mDNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mDFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\noindent
				\ifthenelse{\equal{1}{\@mDTipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 1
		\end{minipage}\hfill %Fim minipage 1
		\noindent\begin{minipage}[t]{0.45\textwidth}\vspace{0pt}
			\setlength{\parindent}{0pt} % Remove o recuo dentro da minipage
			%Membro 2
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mANome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mAFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\noindent
				\ifthenelse{\equal{1}{\@mATipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			\vspace{2.5\baselineskip}
			%Membro 3
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mCNome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mCFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mCTipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 3
			\vspace{2.5\baselineskip}
			%Membro 4
			\noindent{\fontsize{12}{0.5\baselineskip}\selectfont \@mENome\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont \@mEFiliacao\par}
			\noindent{\fontsize{10}{0.5\baselineskip}\selectfont\par
				\ifthenelse{\equal{1}{\@mETipo}}{
					\ifthenelse{\boolean{ing}}{Internal Examiner}{Membro Interno}
				}{
					\ifthenelse{\boolean{ing}}{External Examiner}{Membro Externo}
				}\par}
			%Fim Membro 4
		\end{minipage}
	}{}
	
	\restoregeometry
	\clearpage
}
\DisemulatePackage{titlesec}
\RequirePackage{titlesec}
%======================== CAPÍTULOS SESSÕES E SUBSESSÕES ============================

% chapter definition
\ifthenelse{\boolean{ing}}{}{\renewcommand{\chaptername}{CAPÍTULO}}
% Formatação do capítulo
\titleformat{\chapter}[display]
{\LARGE\filleft} % Formatação do título
{\LARGE\MakeUppercase{\chaptertitlename} \thechapter} % Nome do capítulo (CAPÍTULO 1)
{1pt} % Espaço entre o nome do capítulo e o título
{\color{ppgmsbC1}\titlerule[2pt] 
	\vspace{0.05cm}
	\LARGE} 
[\vspace{0.05cm}% % Reduzir o espaçamento aqui
{\color{ppgmsbC1}\titlerule[2pt]}] % Linha inferior com 2pt de espessura

%formatação section, subsection e subsubsections
% Configuração das Seções (Nível 1)
\titleformat{\section} % Define a formatação do título de seção
{\Large\bfseries\color{ppgmsbC2}\raggedright} % Fonte 16pt, Negrito, Cor ppbmsbC2, Alinhado à esquerda
{\thesection} % Exibe a numeração da seção
{0.5cm} % Espaçamento entre a numeração e o título
{} % Texto do título diretamente sem prefixo
[] % Linha abaixo do título

% Configuração das Subseções (Nível 2)
\titleformat{\subsection} % Define a formatação do título de subseção
{\large\bfseries\color{ppgmsbC3}\raggedright} % Fonte 14pt, Negrito, Cor ppbmsbC3, Alinhado à esquerda
{\thesubsection} % Exibe a numeração da subseção
{0.5cm} % Espaçamento entre a numeração e o título
{} % Texto do título diretamente sem prefixo

% Configuração das Subsubseções (Nível 3) sem numeração, mas no sumário
\titleformat{\subsubsection} % Define a formatação do título de subsubseção
{\normalsize\color{ppgmsbC3}\itshape\raggedright} % Fonte 12pt, Negrito-Itálico, Alinhado à esquerda
{} % Remove a numeração
{0.5cm} % Espaçamento entre a numeração (inexistente) e o título
{} % Texto do título diretamente sem prefixo

% Faz com que as subsubseções apareçam no sumário
\setcounter{secnumdepth}{2} % Define a profundidade de numeração até \subsection
\setcounter{tocdepth}{3} % Faz \subsubsection aparecer no sumário




%======================== FIM CAPÍTULOS SESSÕES E SUBSESSÕES ============================

%=========== ESPAÇAMENTOS ENTRE PARÁGRAFOS SESSÕES =======
\RequirePackage{indentfirst} % Indenta o primeiro parágrafo após seções
\setlength{\parindent}{1.27cm} % Define o recuo do parágrafo
\setlength{\parskip}{0pt}      % Remove espaço extra entre parágrafos
\OnehalfSpacing                % Define espaçamento de 1,5 linhas (APA)




%=================== AGRADECIMENTOS COM CORTE =======================
\newcommand{\agradecimentosTexto}{} % onde armazenaremos o conteúdo

\newenvironment{agradecimentos}
{
	\ifthenelse{\boolean{ing}}{
		\chapter*{Acknowledgements}
	}{
		\chapter*{Agradecimentos}
	}
	\renewcommand{\agradecimentosTexto}{}%
	\Collect@Body\processaAgradecimentos
}
{}

\makeatletter
\newcommand{\processaAgradecimentos}[1]{%
	\def\agradecimentosTexto{#1}%
	\StrLen{\agradecimentosTexto}[\tamanhoAgradecimento]%
	\ifnum\tamanhoAgradecimento>1000
	\StrLeft{\agradecimentosTexto}{1000}[\agradecimentosTexto]%
	\textcolor{red}{\textbf{Aviso: o texto de agradecimentos foi truncado para 1000 caracteres.}}%
	\fi
	\agradecimentosTexto%
}
\makeatother
%=================== DEDICATÓRIA =======================

%=================== DEDICATÓRIA COM LIMITE ==========================
\newcommand{\dedicarTexto}{}  % Armazena o conteúdo digitado

\makeatletter
\newenvironment{dedicar}
{   
	\ifthenelse{\boolean{ing}}{
		\chapter*{Dedication}
		%\addcontentsline{toc}{chapter}{Dedication}
	}{
		\chapter*{Dedicatória}
		%\addcontentsline{toc}{chapter}{Dedicatória}
	}
	\renewcommand{\dedicarTexto}{}%
	\Collect@Body\processaDedicar
}
{}

\newcommand{\processaDedicar}[1]{%
	\def\dedicarTexto{#1}%
	\StrLen{\dedicarTexto}[\tamanhoDedicar]%
	\ifnum\tamanhoDedicar>400
	\StrLeft{\dedicarTexto}{400}[\dedicarTexto]%
	\textcolor{red}{\textbf{Aviso: a dedicatória foi truncada para 400 caracteres.}}%
	\fi
	
	% Mantém exatamente a estrutura original:
	\vspace*{\stretch{1}}  % Espaço no topo
	\begin{flushright}
		\begin{minipage}{0.6\textwidth}  % Reduz a largura
			\raggedleft
			\dedicarTexto
		\end{minipage}
	\end{flushright}
	\vspace*{\stretch{2}}  % Espaço no fim
}
\makeatother

%=========================== RESMUNO LETRA VERNACULA ============
%======================= RESUMO ======================

\makeatletter
\newcommand{\palavraschavecontent}{}
\newenvironment{resumo}[1][] % #1 para as palavras-chave (argumento opcional)
{
	\chapter*{Resumo}
	%\addcontentsline{toc}{chapter}{Resumo}
	\ifstrempty{#1}%
	{\renewcommand{\palavraschavecontent}{}}%
	{\renewcommand{\palavraschavecontent}{\vspace{2cm}\noindent\textbf{Palavras-chave:} #1}}%
	\noindent
	\par\noindent\ignorespaces
}
{

	\palavraschavecontent
	\clearpage
}
\makeatother


%====================== RESUMO FIM =================
%======================= ABSTRAC ===================
\makeatletter
\newcommand{\wordschavecontent}{}
\newenvironment{newAbstract}[1][] % #1 para as palavras-chave (argumento opcional)
{
	\chapter*{Abstract}
	%\addcontentsline{toc}{chapter}{Abstract}
	\ifstrempty{#1}%
	{\renewcommand{\wordschavecontent}{}}%
	{\renewcommand{\wordschavecontent}{\vspace{2cm}\noindent\textbf{Keywords:} #1}}%
	\noindent
	\par\noindent\ignorespaces
}
{

	\wordschavecontent
	\clearpage
}
\makeatother
%======================= LISTAS ================
\makeatletter
% Removendo o título da lista de figuras
\renewcommand{\listfigurename}{}
% Removendo o título da lista de tabelas
\renewcommand{\listtablename}{}
% Configurações para a Lista de Ilustrações (Figuras)
\renewcommand{\cftfigurepresnum}{Fig. }
\renewcommand{\cftfigureaftersnum}{\hspace{2em}\textcolor{black}}
\renewcommand{\cftfigurepagefont}{\textcolor{ppgmsbC3}}
\setlength{\cftfigurenumwidth}{5em}

\newcommand{\listaDeIlustracoes}{
	\begingroup
	\let\oldaddcontentsline\addcontentsline
	\renewcommand{\addcontentsline}[3]{}
	\ifthenelse{\boolean{ing}}{
		\chapter*{List of Figures}
		\renewcommand{\listfigurename}{}
			}{
		\chapter*{Lista de Ilustrações}
		\renewcommand{\listfigurename}{}
		
	}
	\setlength{\beforechapskip}{-50pt}
	\listoffigures
	\let\addcontentsline\oldaddcontentsline
	\endgroup
	\clearpage
}

% Configurações para a Lista de Tabelas
\renewcommand{\cfttablepresnum}{Tbl.\space}
\renewcommand{\cfttableaftersnum}{\hspace{1em}\textcolor{black}}
\renewcommand{\cfttablepagefont}{\textcolor{ppgmsbC3}}
\setlength{\cfttablenumwidth}{4em}

\newcommand{\listaDeTabelas}{
	\begingroup
	\let\oldaddcontentsline\addcontentsline
	\renewcommand{\addcontentsline}[3]{}
	\ifthenelse{\boolean{ing}}{
		\chapter*{List of Tables}
		\setlength{\beforechapskip}{-50pt}
		\renewcommand{\listtablename}{}
		\listoftables
	}{
		\chapter*{Lista de Tabelas}
		\setlength{\beforechapskip}{-50pt}
		\renewcommand{\listtablename}{}
		\listoftables
	}
	\let\addcontentsline\oldaddcontentsline
	\endgroup
	\clearpage
}

\makeatother

% ---
% ---



%======================= LISTA ALGORITMOS ========
\makeatletter

\SetKwComment{Comment}{/* }{ */}
	\ifthenelse{\boolean{ing}}{
			\newcommand{\listaDeAlgoritmos}{
			\listofalgorithms
			\cleardoublepage	
	}
	}{
			\SetAlgorithmName{Algoritmo}{}{Lista de Algoritmos}
			\newcommand{\listaDeAlgoritmos}{
				\listofalgorithms
				%\addcontentsline{toc}{chapter}{Lista de Algoritmos}
				\cleardoublepage	
				}
			}
\makeatother
%======================= COMANDOS DE SUMÁRIO ================
\renewcommand{\contentsname}{Sumário}






%============================================================

%****************Comando Especiais ********************
\makeatletter
\newcommand{\sen}{\operatorname{sen}}
\newcommand{\senh}{\operatorname{senh}}
\newcommand{\tg}{\operatorname{tg}}
\newcommand{\tgh}{\operatorname{tgh}}
\newcommand{\cossec}{\operatorname{cossec}}
\newcommand{\cotg}{\operatorname{cotg}}
\newcommand{\cossech}{\operatorname{cossech}}
\newcommand{\cotgh}{\operatorname{cotgh}}
\newcommand{\arcsen}{\operatorname{arcsen}}

%cria o comando \chaves{arg1}
\newcommand{\chaves}[1]
{\ensuremath{\left\lbrace #1 \right\rbrace}}
\makeatother
%Define o estilo do texto matemático
\everymath{\displaystyle}

%======================CABEÇALHO E RODAPÉ ===============
% Criar um novo estilo de página
\makepagestyle{ppgmsbPages}
\makeheadfootruleprefix{ppgmsbPages}{\color{ppgmsbC1}}{\color{ppgmsbC1}}
\makeheadrule{ppgmsbPages}{\textwidth}{\normalrulethickness}
\makefootrule{ppgmsbPages}{\textwidth}{0.4pt}{4pt}
\makeevenfoot {ppgmsbPages}{}{\small  \thepage} {}
\makeoddfoot {ppgmsbPages}{}{\small \thepage} {}

% Configurar os marcadores
% Configurar os marcadores
\makepsmarks{ppgmsbPages}{
	\uppercaseheads
	\createmark{chapter}{both}{nonumber}{}{}
}

\makeevenhead{ppgmsbPages}{\includegraphics[height=0.5cm]{figuras/logoso.png}}{}{\small\itshape\leftmark}
\makeoddhead{ppgmsbPages}{\includegraphics[height=0.5cm]{figuras/logoso.png}}{}{\small\itshape\rightmark}


%================ FIM CABEÇALHO E RODAPE ===================

%================ SISTEMA DE REFERECIAS======================
\RequirePackage[natbibapa,apaciteclassic]{apacite} % natbibapa para compatibilidade com o pacote natbib
\ifthenelse{\boolean{ing}}
{\renewcommand{\bibname}{References}} % Se 'ing' for verdadeiro
{\renewcommand{\bibname}{Referências}} % Se 'ing' for falso
\bibliographystyle{apacite}
\newenvironment{citacao}{
	\begin{flushright}
		\list{}%
		\footnotesize
		\addtolength{\leftskip}{2.27cm}%
		\item[]%

		\begin{singlespace}
			}{%

		\end{singlespace}
		\endlist
	\end{flushright}
}%



%================ COMANDO CITAÇÃO ======================
%\newcommand{\fonte}[1]{%
%	\vspace{2pt}%
%	\begin{flushleft}
%		\small
%		\textbf{Fonte:} \if\relax\detokenize{#1}\relax Próprio autor\else #1\fi
%	\end{flushleft}
%}
%================ COMANDO NOTA PARA TABELAS ======================
\newcommand{\nota}[1]{
	\par
	\small
	\textbf{\textit{Nota}:} #1
	\par
}

%================== comando ODS==========================
% Define o comando ODSdoTrabalho
	\newcommand{\ODSdoTrabalho}[5]{
		\begin{figure}[h]
			\centering
			\ifx\relax#1\relax\else
			\includegraphics[width=0.18\textwidth]{figuras/#1}\fi
			\ifx\relax#2\relax\else
			\hspace{1pt}\includegraphics[width=0.18\textwidth]{figuras/#2}\fi
			\ifx\relax#3\relax\else
			\hspace{1pt}\includegraphics[width=0.18\textwidth]{figuras/#3}\fi
			\ifx\relax#4\relax\else
			\hspace{1pt}\includegraphics[width=0.18\textwidth]{figuras/#4}\fi
			\ifx\relax#5\relax\else
			\hspace{1pt}\includegraphics[width=0.18\textwidth]{figuras/#5}\fi
		\end{figure}
	}

